*Center predictors.
COMPUTE money = money - 13.007514231499044.
COMPUTE acres = acres - 12.955907020872855.
IF  (house = 0) house=-1.
EXECUTE.

*Multilevel model with random intercept .
MIXED voting WITH money
 /FIXED= money
 /RANDOM=INTERCEPT | SUBJECT(state)
 /PRINT=SOLUTION.

*Multilevel model with random intercept and random slope .
MIXED voting WITH money
 /FIXED= money
 /RANDOM=INTERCEPT money| SUBJECT(state)
 /PRINT=SOLUTION.

*Multilevel model with random intercept, random slope, and non-default covariance matrix.
MIXED voting WITH party
 /FIXED= party
 /RANDOM=INTERCEPT party | SUBJECT(state) COVTYPE(UN)
 /PRINT=SOLUTION.

*Moderated multilevel model with random intercept and a covariate .
MIXED voting WITH house money acres
 /FIXED= house money acres money*acres
 /RANDOM=INTERCEPT | SUBJECT(state)
 /PRINT=SOLUTION.

*Simple effects testing in multilevel models .
COMPUTE lowmoney = money + 18.437599427762795.
COMPUTE highmoney = money - 18.437599427762795.
COMPUTE lowacres = acres + 41.562242563739005.
COMPUTE highacres = acres - 41.562242563739005.
EXECUTE.
*Simple effect of Money for states with low acreage.
MIXED voting WITH house money lowacres
 /FIXED= house money lowacres money*lowacres
 /RANDOM=INTERCEPT | SUBJECT(state)
 /PRINT=SOLUTION.
*Simple effect of Money for states with high acreage.
MIXED voting WITH house money highacres
 /FIXED= house money highacres money*highacres
 /RANDOM=INTERCEPT | SUBJECT(state)
 /PRINT=SOLUTION.
*Simple effect of Acres for legislators with low campaign contributions.
MIXED voting WITH house lowmoney acres
 /FIXED= house lowmoney acres lowmoney*acres
 /RANDOM=INTERCEPT | SUBJECT(state)
 /PRINT=SOLUTION.
*Simple effect of Acres for legislators with high campaign contributions.
MIXED voting WITH house highmoney acres
 /FIXED= house highmoney acres highmoney*acres
 /RANDOM=INTERCEPT | SUBJECT(state)
 /PRINT=SOLUTION.

*Baseline Model to calculate Effect Size.
MIXED voting
 /FIXED= INTERCEPT
 /RANDOM=INTERCEPT | SUBJECT(state)
 /PRINT=SOLUTION.

***** Advanced Applications *****.
*3-level Multilevel model with random intercept.
MIXED voting WITH money acres
 /FIXED= money acres money*acres
 /RANDOM=INTERCEPT | SUBJECT(state*party)
 /RANDOM=INTERCEPT | SUBJECT(party)
 /PRINT=SOLUTION.

*Nested Growth Curve Models (HYPOTHETICAL DATA) - Pretend that each legislator's vote on all pro-tobacco legislation was recorded (instead of the overall percentage) and the sequential order of each vote was stored in a variable called "time".
MIXED voting WITH money time
 /FIXED= money time money*time
 /RANDOM=INTERCEPT time | SUBJECT(legislator*state) COVTYPE(UN)
 /RANDOM=INTERCEPT time | SUBJECT(state) COVTYPE(UN)
 /PRINT=SOLUTION.

*Generalized Linear Mixed Models - Poisson.
**Predicting the number of legislators from each state as a function of gross state product/economic productivity of state. 
GENLINMIXED
  /FIELDS TARGET=n_reps
  /TARGET_OPTIONS DISTRIBUTION=POISSON LINK=LOG
  /FIXED  EFFECTS=gsp USE_INTERCEPT=TRUE
 /RANDOM USE_INTERCEPT =TRUE SUBJECTS =state.

*Generalized Linear Mixed Models - Multilevel logistic regression.
**Predicting party membership as a function of tobacco company donations.
GENLINMIXED
  /FIELDS TARGET=party
  /TARGET_OPTIONS DISTRIBUTION=BINOMIAL LINK=LOGIT
  /FIXED  EFFECTS=voting
  /RANDOM USE_INTERCEPT=TRUE SUBJECTS=state.